unit Unit1;

//     Arc.   
//    (   ),   
//       (X3,Y3)   (X4,Y4).

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Panel1: TPanel;
    Image1: TImage;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

const XC = 200;
      YC = 200;
      DL = 100;

procedure ClearImage (RqImg : TImage);
var R1 : TRect;
begin
  with RqImg.Canvas
  do begin
    Brush.Color := RqImg.Parent.Brush.Color;
    Brush.Style := bsSolid;
    R1 := Rect( -1, -1, RqImg.Width + 1, RqImg.Height + 1);
    Rectangle(R1);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ClearImage (Image1);
  with Image1.Canvas
  do begin
    //   
    Pen.Color := clBlue;
    MoveTo(XC,YC);
    LineTo(XC, 0);
    MoveTo(XC,YC);
    LineTo(0, YC);
    //  
    Pen.Color := clRed;
    Arc( XC-DL,YC-DL,  XC+DL,YC+DL,  XC,0,  0,YC);
    //   
    TextOut(XC,0,'L3 ( X3, Y3 )');
    TextOut(0,YC,'L4 ( X4, Y4 )');
    TextOut(10, Image1.Height-40,
            'Arc ( XB, YB,   XE, YE,   X3, Y3,   X4, Y4 )');
    TextOut(10, Image1.Height-20,
            '        ( L3 )');
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ClearImage (Image1);
  with Image1.Canvas
  do begin
    //   
    Pen.Color := clBlue;
    MoveTo(XC,YC);
    LineTo(XC, 0);
    MoveTo(XC,YC);
    LineTo(0, YC);
    //  
    Pen.Color := clRed;
    Arc( XC-DL,YC-DL, XC+DL,YC+DL, 0,YC,  XC,0);
    //   
    TextOut(0,YC,'L3 ( X4, Y4 )');
    TextOut(XC,0,'L4 ( X3, Y3 )');
    TextOut(10, Image1.Height-40,
            'Arc ( XB, YB,   XE, YE,   X4, Y4,   X3, Y3 )');
    TextOut(10, Image1.Height-20,
            '        ( L3 )');
  end;
end;

end.
